function varargout = Evokedresponse(varargin)
% EVOKEDRESPONSE MATLAB code for Evokedresponse.fig
%      EVOKEDRESPONSE, by itself, creates a new EVOKEDRESPONSE or raises the existing
%      singleton*.
%
%      H = EVOKEDRESPONSE returns the handle to a new EVOKEDRESPONSE or the handle to
%      the existing singleton*.
%
%      EVOKEDRESPONSE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EVOKEDRESPONSE.M with the given input arguments.
%
%      EVOKEDRESPONSE('Property','Value',...) creates a new EVOKEDRESPONSE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Evokedresponse_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Evokedresponse_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Evokedresponse

% Last Modified by GUIDE v2.5 11-Oct-2016 22:01:40

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Evokedresponse_OpeningFcn, ...
                   'gui_OutputFcn',  @Evokedresponse_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Evokedresponse is made visible.
function Evokedresponse_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Evokedresponse (see VARARGIN)

% Choose default command line output for Evokedresponse
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% list box
if nargin == 3,
    initial_dir = strcat(pwd,'\Evoked_response_data\*.atf');
elseif nargin > 4
    if strcmpi(varargin{1},'dir')
        if exist(varargin{2},'dir')
            initial_dir = varargin{2};
        else
            errordlg('Input argument must be a valid directory','Input Argument Error!')
            return
        end
    else
        errordlg('Unrecognized input argument','Input Argument Error!');
        return;
    end
end
% Populate the listbox
load_listbox(initial_dir,handles)
% Return figure handle as first output argument

% UIWAIT makes Evokedresponse wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = Evokedresponse_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on selection change in listbox1.
function listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox1

get(handles.figure1,'SelectionType');

index_selected = get(handles.listbox1,'Value');
file_list = get(handles.listbox1,'String');
filename = file_list{index_selected};

%save work space
clear hObject eventdata handles 
save('Evokedresponse.mat')

% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on selection change in listbox2.
function listbox2_Callback(hObject, eventdata, handles)
% hObject    handle to listbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox2

% --- Executes during object creation, after setting all properties.
function listbox2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in listbox3.
function listbox3_Callback(hObject, eventdata, handles)
% hObject    handle to listbox3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox3 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox3

% --- Executes during object creation, after setting all properties.
function listbox3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in listbox4.
function listbox4_Callback(hObject, eventdata, handles)
% hObject    handle to listbox4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox4 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox4

get(handles.figure1,'SelectionType');

%call work space
load('Evokedresponse.mat')

index_selected4 = get(handles.listbox4,'Value');
file_list4 = get(handles.listbox4,'String');
filename4 = file_list4{index_selected4};

%save work space
clear hObject eventdata handles
save('Evokedresponse.mat')

% --- Executes during object creation, after setting all properties.
function listbox4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function load_listbox(dir_path,handles)
%cd (dir_path)
dir_struct = dir(dir_path);
[sorted_names,sorted_index] = sortrows({dir_struct.name}');
handles.file_names = sorted_names;
handles.is_dir = [dir_struct.isdir];
handles.sorted_index = sorted_index;
guidata(handles.figure1,handles)
set(handles.listbox1,'String',handles.file_names,'Value',1)

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Variable declaration
Headerlines = '';

%call work space
load('Evokedresponse.mat')

%het file
%Variable declaration
time = 0;
mV = 0;
i = 0;
j = 0;
k = 0;
%temp_find_count = 0;    %for SpikeImage
%find_count = 0;         %for SpikeImage

temp_find_count_x = 0;    %for SpikeImage
temp_find_count_y = 0;    %for SpikeImage
find_count_x = 0;         %for SpikeImage
find_count_y = 0;         %for SpikeImage

%select file to analyze
FileCount = size(file_list);
SelectFileCount = size(index_selected);
filecnt = 0;

if isempty(Headerlines),Headerlines = 3; end

%get file
for i = 1:FileCount(1,1)
    for j = 1:SelectFileCount(1,2)
        if i == index_selected(1,j)
            filecnt = filecnt + 1;
            SelectFileName{filecnt,1} = file_list{i};
            X = textread(strcat(pwd,'\Evoked_response_data\',file_list{i}),'','headerlines',Headerlines);
            
            temp_find_count_x = size(find(X(2,:)));
            temp_find_count_y = size(find(X(:,2)));
            
            if filecnt == 1
                find_count_x(filecnt,1) = temp_find_count_x(1,2);                
                find_count_y(filecnt,1) = temp_find_count_y(1,1);
                
                temp_time = zeros(find_count_y(filecnt,1), 1);
                temp_mV = zeros(find_count_y(filecnt,1), find_count_x(filecnt,1)-1);
                temp_time = X(:,1);
                temp_mV = X(:,2:find_count_x(filecnt,1));
                time = temp_time;
                mV = temp_mV;
            else
                if max(find_count_x) < temp_find_count_x(1,2) || max(find_count_y) < temp_find_count_y(1,1)
                    temp_time = zeros(temp_find_count_y(1,1), filecnt-1);
                    temp_mV = zeros(temp_find_count_y(1,1), temp_find_count_x(1,2)-1, filecnt-1);
                    %temp_time = time;
                    temp_time(1:max(find_count_y),1:filecnt-1) = time(:,1:filecnt-1);
                    %temp_mV = mV;
                    temp_mV(1:max(find_count_y),1:max(find_count_x)-1,1:filecnt-1) = mV(:,:,1:filecnt-1);
                    time = temp_time;
                    mV = temp_mV;
                    
                    find_count_x(filecnt,1) = temp_find_count_x(1,2);                
                    find_count_y(filecnt,1) = temp_find_count_y(1,1);
                    
                    temp_time = zeros(find_count_y(filecnt,1), 1);
                    temp_mV = zeros(find_count_y(filecnt,1), find_count_x(filecnt,1)-1);
                    temp_time = X(:,1);
                    temp_mV = X(:,2:find_count_x(filecnt,1));
                    time(:,filecnt) = temp_time;
                    mV(:,:,filecnt) = temp_mV;
                else
                    find_count_x(filecnt,1) = temp_find_count_x(1,2);                
                    find_count_y(filecnt,1) = temp_find_count_y(1,1);
                    
                    temp_time = zeros(find_count_y(filecnt,1), 1);
                    temp_mV = zeros(find_count_y(filecnt,1), find_count_x(filecnt,1)-1);
                    %temp_time = X(:,1);
                    temp_time(1:find_count_y(filecnt,1),1) = X(:,1);
                    %temp_mV = X(:,2:find_count_x);
                    temp_mV(1:find_count_y(filecnt,1),1:find_count_x(filecnt,1)-1) = X(:,2:find_count_x(filecnt,1));
                    time(1:find_count_y(filecnt,1),filecnt) = temp_time;
                    mV(1:find_count_y(filecnt,1),1:find_count_x(filecnt,1)-1,filecnt) = temp_mV;
                end
            end
        end
    end
end

%Plot
for k = 1:SelectFileCount(1,2)
    f=figure;
    hold('on');
    plot(time(1:find_count_y(k,1),k),mV(1:find_count_y(k,1),1:find_count_x(k,1)-1,k))
    title(SelectFileName(k,1),'FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    xlabel('Time (ms)','FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    ylabel('Vm (mV)','FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    set(gca,'FontSize',16,'FontWeight','bold','FontName','lr SVbN','LineWidth',2,'TickDir','out');
    hold('off');
end

%get sweep number
for i = 1:max(find_count_x)-1
    SweepList{i,1} = strcat('Sweep #',num2str(i));
end
set(handles.listbox4,'String',SweepList,'Value',1)

%save file
clear hObject eventdata handles f
save('Evokedresponse.mat')

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Variable declaration
MinimumValue = '';
MaximumValue = '';
MinimumValue2 = '';
MaximumValue2 = '';

%call work space
load('Evokedresponse.mat')

%get file to visualize plot
%Variable declaration
time2 = 0;
mV2 = 0;
i = 0;
j = 0;
k = 0;
temp_find_count = 0;    %for SpikeImage

if isempty(MinimumValue),MinimumValue = 316; end
if isempty(MaximumValue),MaximumValue = 617; end
%if isempty(MaximumValue),MaximumValue = min(find_count_y); end

MinimumValue2 = find((time(:,1)==MinimumValue));
MaximumValue2 = find((time(:,1)==MaximumValue));

%intake file
for i = 1:SelectFileCount(1,2)
    DataCount(i,1) = MaximumValue2-MinimumValue2+1;
    j = MinimumValue2:MaximumValue2;time2(j-MinimumValue2+1,i) = time(j,i); mV2(j-MinimumValue2+10001,1:max(find_count_x)-1,i) = mV(j,1:max(find_count_x)-1,i);
    j = MaximumValue2-MinimumValue2+2:MaximumValue2-MinimumValue2+10001;mV2(j+10000,1:max(find_count_x)-1,i) = 0;
end

%Plot
for k = 1:SelectFileCount(1,2)
    f=figure;
    hold('on');
    plot(time2((1:MaximumValue2-MinimumValue2+1),k),mV2((10001:MaximumValue2-MinimumValue2+10001),1:find_count_x(k,1)-1,k))
    title(file_list{index_selected(1,k)},'FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    xlabel('Time (ms)','FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    ylabel('Vm (mV)','FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    set(gca,'FontSize',16,'FontWeight','bold','FontName','lr SVbN','LineWidth',2,'TickDir','out');
    hold('off');
end

%save work space
clear hObject eventdata handles f
save('Evokedresponse.mat')

% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%call workspace
load('Evokedresponse.mat')

%read file visualize plot
%Variable declaration
time3 = 0;
mV3 = 0;
i = 0;
j = 0;
k = 0;

%get file number
FileCount = size(file_list4);
SelectFileCount2 = size(index_selected4);
filecnt = 0;

%intake file
for i = 1:FileCount(1,1)
    for j = 1:SelectFileCount2(1,2)
        if i == index_selected4(1,j)
            filecnt = filecnt + 1;
            if filecnt == 1
                SelectSweepList = num2str(index_selected4(1,j));
                mV3 = mV2(:,i,:);
            else
                SelectSweepList = strcat(SelectSweepList,',',num2str(index_selected4(1,j)));
                mV3(:,filecnt,:) = mV2(:,i,:);
            end
        end
    end
end
time3 = time2;

%Plot
for k = 1:SelectFileCount(1,2)
    f=figure;
    hold('on');
    plot(time3((1:MaximumValue2-MinimumValue2+1),k),mV3((10001:MaximumValue2-MinimumValue2+10001),1:SelectFileCount2(1,2),k))
    title(file_list{index_selected(1,k)},'FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    xlabel('Time (ms)','FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    ylabel('Vm (mV)','FontSize',16,'Color','black','FontWeight','bold','FontName','lr SVbN');
    set(gca,'FontSize',16,'FontWeight','bold','FontName','lr SVbN','LineWidth',2,'TickDir','out');
    hold('off');
end

%save work space
clear hObject eventdata handles f
save('Evokedresponse.mat')

% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Variable declaration
temp_Rheobase2 = '';

%call work space
load('Evokedresponse.mat')
%Variable declaration
RMP = 0;            %for RMP
MFR = 0;            %for Mean Firing Rate
cnt = 0;            %for Mean Firing Rate
cnt2 = 0;           % for Mean Firing Rate
i = 0;
j = 0;
k = 0;
temp_find_count = 0;
SweepListRMP = '';
SweepListMFR = '';

% %set Rheobase
% Rheobase = zeros(1, SelectFileCount(1,2));
% if isempty(temp_Rheobase2) == false
%     i = 1:numel(temp_Rheobase2);Rheobase(1,i) = temp_Rheobase2(1,i);
% end
% 
% %set Rheobase to count spike
% for i = 1:SelectFileCount(1,2)
%     cnt2=(Rheobase(1,i)<=mV3((10001:DataCount(i,1)+10000),:,i));
%     cnt(1,i)=cnt2(1)+sum(0==cnt2(1:end-1) & 1==cnt2(2:end));
%     for j = 1:SelectFileCount2(1,2)
%         cnt2=(Rheobase(1,i)<=mV3((10001:DataCount(i,1)+10000),j,i));
%         cnt(j+1,i)=cnt2(1)+sum(0==cnt2(1:end-1) & 1==cnt2(2:end));
%     end
% end

%count spike number
for i = 1:SelectFileCount(1,2)
    for j = 1:SelectFileCount2(1,2)
        temp_find_count = size(findpeaks(mV3(:,j,i),'MinPeakProminence',5,'MinPeakDistance',100));        
        cnt2(j,i) = temp_find_count(1,1);
    end
end
cnt = sum(cnt2);
for i = 1:SelectFileCount(1,2)
    for j = 1:SelectFileCount2(1,2)
        cnt(j+1,i) = cnt2(j,i);
    end
end

%RMP
for i = 1:SelectFileCount(1,2)
    RMP(1,i) = vpa(mean2(mV3((10001:DataCount(i,1)+10000),:,i)));
    for j = 1:SelectFileCount2(1,2)
        RMP(j+1,i) = vpa(mean(mV3((10001:DataCount(i,1)+10000),j,i)));
    end
end
%Mean Firing Rate
for i = 1:SelectFileCount(1,2)
    for j = 1:SelectFileCount2(1,2)+1
        %MFR(j,i) = vpa(cnt(j,i) / (time3(DataCount(i,1),1) / 1000));
        MFR(j,i) = vpa(cnt(j,i) / ((time3(DataCount(i,1),1)-time3(1,1)) / 1000));
    end
end

%generate folder to analyze
mkdir(strcat(pwd,'\Evoked_response_saved_data\analyzed_RMP and Mean Firing Rate_',datestr(now,'yyyymmdd_HHMMSS')));
temp_directory = strcat(pwd,'\Evoked_response_saved_data\analyzed_RMP and Mean Firing Rate_',datestr(now,'yyyymmdd_HHMMSS'));

fid=fopen(strcat(temp_directory,'\analytext.txt'), 'w');
for i = 1:SelectFileCount2(1,2)
    SweepListRMP = strcat(SweepListRMP,'Sweep # ',num2str(index_selected4(1,i)),' RMP\t');
    SweepListMFR = strcat(SweepListMFR,'Sweep # ',num2str(index_selected4(1,i)),' MFR\t');
end
fprintf(fid,strcat('filename\tIntegrated RMP\tIntegrated MFR\t',SweepListRMP,SweepListMFR,'\r\n'));
for i = 1:SelectFileCount(1,2)
    fprintf(fid,strcat(file_list{index_selected(1,i)},'\t%g\t'), RMP(1,i));
    fprintf(fid,'%g\t', MFR(1,i));
    j = 1:SelectFileCount2(1,2);fprintf(fid,'%g\t', RMP(j+1,i));
    j = 1:SelectFileCount2(1,2);fprintf(fid,'%g\t', MFR(j+1,i));
    fprintf(fid,'\r\n');
end
fclose(fid);

%save work space
clear hObject eventdata handles
save('Evokedresponse.mat')

uiwait(msgbox('RMP and Mean Firing Rate were Calculated','Success','modal'));

% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

ESI
close Evokedresponse

function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double

% input headerlines
temp_Headerlines = get(hObject,'String');
%call work space
load('Evokedresponse.mat')
Headerlines = str2num(temp_Headerlines);
clearvars temp_Headerlines
%save work space
clear hObject eventdata handles
save('Evokedresponse.mat')

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double

%input min of data range
temp_MinimumValue = get(hObject,'String');
%call work space
load('Evokedresponse.mat')
MinimumValue = str2num(temp_MinimumValue);
clearvars temp_MinimumValue
%save work space
clear hObject eventdata handles
save('Evokedresponse.mat')

% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double

%input max of data range
temp_MaximumValue = get(hObject,'String');
%call workspace
load('Evokedresponse.mat')
MaximumValue = str2num(temp_MaximumValue);
clearvars temp_MaximumValue
%save workspace
clear hObject eventdata handles
save('Evokedresponse.mat')

% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
